#include "peterson.h"

my_global_data_t *p;
int shmId = -1;

// get shared memory and attach it to own memory map
void getShm() {

    if ( 0 > (shmId = shmget(SHM_KEY, 
                             sizeof(my_global_data_t),
                             IPC_CREAT|0x1ff)) ) {
	perror("Problem at shmget()");
	exit(10);
    }

    if ( NULL == (p = shmat(shmId,NULL,0)) ) {
	perror("Problem at shmat()");
	exit(10);
    }
}

// put money into account
void input2Acc(int pid, int x) {

    int oldBal = p->u.balance;

    p->u.balance = oldBal + x;

    printf("PID %d inputs %d  old balance %d - new balance: %d\n",
	   pid,x,oldBal,p->u.balance);
}

// withdraw money from account
void withdrawFromAccount(int pid, int sum) {

    int oldBal =  p->u.balance;

    sleep(1);

    if ( oldBal > sum ) {
	p->u.balance = oldBal - sum;
	printf("PID %d draws %d  old balance %d - new balance: %d\n",
               pid,sum,oldBal,p->u.balance);
    }
    else {
	printf("PID %d cannot draw %d - balance: %d\n",
	       pid,sum,p->u.balance);
    }
}

//enter critical region according to peterson's algorithm
void enter_critical(int pid) {
    int i, j;

    for(i = 0; i < N; i++)
    {
	p->c.interested[pid] = i+ 1;
	p->c.turn[i] = pid;

	for(j = 0; j < N; j++)
	    /* busy waiting */
	    if(j != pid)
		while (p->c.interested[j] >= p->c.interested[pid] &&
                       p->c.turn[i] == pid) 
		    ;
    }
}

//leave critical region according to peterson's algorithm
void leave_critical(int pid) {

    p->c.interested[pid] = 0;
}


int main(int argc, char **argv) {

    int iCnt;      //counter
    int pid;       //pid of process
    int intoAcc;   //money to put into account once
    int duration;  //duration to sleep

    //first argument: pid (from 0..N-1)
    //second argument: money to put into bank account
    if ( argc < 3 ) {
	printf("Pid missing in command line - exit\n");
	exit(10);
    }

    //initialize random()
    srandom(time(NULL) + getpid());

    //store arguments to local variables
    pid = atoi(argv[1]);
    intoAcc = atoi(argv[2]);

    //get shared memory
    getShm();

    //initialize: process with pid is not interested
    p->c.interested[pid] = 0;

    //initialize account
    if(pid == 0)
	p->u.balance = 3000;

    //put money (second argument) into bank account
    enter_critical(pid);
    input2Acc(pid,intoAcc);
    leave_critical(pid);

    //try to withdraw 100 money units ten times
    for (iCnt = 0; iCnt < MAX; iCnt++ ) {

	duration = random() % 3;
	sleep(duration);

	enter_critical(pid);

	withdrawFromAccount(pid, 100);

	leave_critical(pid);
    }

    if(0 > shmctl(shmId, IPC_RMID, 0))
    {
	perror("Problem at shmctl()");
	exit(10);
    }

    if(0 >shmdt(p))
    {
	perror("Problem at shmdt()");
	exit(10);
    }

    exit(0);
}
