#include <stdio.h>
#include <stdlib.h>
#include <string.h> 
#include <errno.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/sem.h>
#include <sys/shm.h>

#define MY_STRING_LEN 100

#define SHM_PERM 0777
#define SHM_KEY 0x2A

/*--- Semaphore key ---*/
#define SEM_KEY 0x2A
#define SEM_NUM 3
#define SEM_PERM 0777

#define SEM_MUTEX 0
#define SEM_EMPTY 1
#define SEM_FULL  2

#define BUFFER_SIZE 5

#if defined(__GNU_LIBRARY__) && !defined(_SEM_SEMUN_UNDEFINED)
/* union semun is defined by including <sys/sem.h> */
#else
/* according to X/OPEN we have to define it ourselves */
union semun {
          int val;                    
            /* value for SETVAL */
          struct semid_ds *buf;       
              /* buffer for IPC_STAT, IPC_SET */
          unsigned short int *array;  
               /* array for GETALL, SETALL */
          struct seminfo *__buf;      
              /* buffer for IPC_INFO */
};
#endif



typedef struct {
    
    /*--- items werden als Stack organisiert:
          Top-of-Stack liegt immer bei t=(numItemsInBuffer-1).
          Ist t == -1, ist der Stack leer ---*/ 
    int numItemsInBuffer;
    char userData[BUFFER_SIZE][MY_STRING_LEN];

} prod_con_shm_t;
