import java.lang.reflect.*;

class Ttt implements MyComparable {
	int t1;
	int t2;

	public Ttt(int x, int y) {
		t1 = x;
		t2 = y;
	}

	public int myCompareTo(Object obj) {


		//BOOLscher Vergleichsoperator fuer 
		// die Abfrage, ob ein Objekt einer bestimmten Klasse
		// angehoert.
		if ( obj instanceof Ttt ) {

			Ttt other = (Ttt)obj;
			int sqThis = t1*t1 + t2*t2;
			int sqOther = other.t1*other.t1 + other.t2*other.t2;

			return ( sqThis - sqOther );

		}
		else return -1;

	}

    // Uberladen der toString()-Methode
    public String toString() {
 
	return "("
               +(new Integer(t1)).toString() 
               + ","
               + (new Integer(t2)).toString()+ ")";

    }

}

public class MyReflectionMain {

    public static void main(String[] args) {

        MyFiniteStack stk1;

        stk1 = new MyFiniteStack();

        stk1.push(new Ttt(1,1));
        stk1.push(new Ttt(-1,1));
        stk1.push(new Ttt(2,1));

        // Jede Klasse hat ein statisches Attribut class,
        // über welches Auskünfte über die Klasse eingeholt werden 
        // können: Die toString() Methode gibt einen Ausdruck der
        // Form "class <Classname>" zurück:
        System.out.println("MyFiniteStack.class = " 
                           + MyFiniteStack.class.toString());
        System.out.println
          ("MyFiniteStack.class.getName() = " 
                           + MyFiniteStack.class.getName());
        
        System.out.println
        ("MyFiniteStack.class.getClass().getName() = " 
             + MyFiniteStack.class.getClass().getName());
        
        // Bei einem konkreten Objekt kann man die Class-Instanz
        // der zugehörigen Klasse mit getClass() erhalten:
        System.out.println
          ("stk1.getClass().getName() = " 
            + stk1.getClass().getName());
        

        
        // Abfrage, ob ein Objekt Instanz einer bestimmten Oberklasse ist:
        System.out.println("stk1 instanceof Object = " 
                           + (stk1 instanceof Object));
     
        // Mit der statischen Methode forName() kann man
        // ein Klassen-Auskunftsobjekt durch Angabe des
        // Klassennamens erhalten:
        try {
        	System.out.println
        	       ("Class.forName(\"MyFiniteStack\").getName() = " 
        			+ Class.forName("MyFiniteStack").getName());
        }
        catch (Exception e) {
        	System.out.println(e);
        }



        // statische Variable class enthält codierte
        // Klassenidentifikation
        if ( stk1.getClass() == MyFiniteStack.class ) {
        	System.out.println("stk1 is of type MyFiniteStack");
        }



        // Mit stk1.getClass().getMethods() erhalten wir
        // einen Array mit Referenzen auf Objekte vom Typ Method.
        // Jedes dieser Method-Objekte repräsentiert eine  Methode
        // des zu untersuchenden Objektes (hier stk1). 
        // Über die Operationen
        // auf Method-Objekten können Auskunftsfunktionen über die
        // Methoden des zu untersuchenden Objektes aufgerufen werden:
        // stk1.getClass().getMethods()[iCnt].toString() liefert
        // die vollständige Deklaration der iCnt'ten Methode
        // von stk1 zurück. stk1.getClass().getMethods()[iCnt].getName()
        // liefert nur den Methodennamen.
        Method[] m = stk1.getClass().getMethods();
        
        for (int i = 0; i < m.length; i++) {
        	System.out.println("Method " + i + ": " + m[i].toString()); 
        }
        
        // Das gleiche noch einmal, ohne explizit ein
        // Objekt m vom Typ "Methodenarray" zu deklarieren:
        for (int iCnt=0; 
        iCnt < stk1.getClass().getMethods().length; 
        iCnt++)
        	System.out.println(
        			"Name stk1, method number "  
        			+ iCnt 
        			+ " is: " 
        			+ stk1.getClass().getMethods()[iCnt].toString());


        // Mit der invoke()-Methode auf dem Method-Objekt 
        // stk1.getClass().getMethods()[iCnt] kann man die iCnt'te
        // Methode des Objektes stk1 aufrufen:
        // Statische Klassenmethoden werden mit invoke(null,parms)
        // aufgerufen, objektabhängige Methoden mit
        // invoke(objectReference,parms). Parms ist ein Array mit
        // Referenzen auf die Parameterobjekte, die beim Methodenaufruf
        // zu verwenden sind. Der Array ist in der Reihenfolge der
        //  Parameterliste zu belegen. (Wie denn sonst wohl ...)
        // Ist der Methodenaufruf parameterlos, wird invoke(...,null)
        // verwendet.

        // invoke() mit statischer Methode, keine Parameter:
        try {
        	System.out.println("Name of method  " 
        			+ stk1.getClass().getMethods()[4].getName()
        			+ " returns "
        			+ MyFiniteStack.getNumExistingStacks()
        			+ " which is the same as "
        			+ stk1.getClass().getMethods()[4].invoke((Object)null));
        }
        catch (java.lang.IllegalAccessException e){
        	System.out.println(e);
        }
        catch (java.lang.reflect.InvocationTargetException e){
        	System.out.println(e);
        }
        catch ( IllegalArgumentException e) {
        	System.out.println(e);
        }

        // Besorge die Parameter der Methoden eines Objektes
        try {
        	for ( int i = 0; i < m.length; i++) {
        		System.out.println("PARAMETER METHOD : "
        				+ i
        				+ ": "
        				+ m[i].getName());
        		Class p[] = 
        			stk1.getClass().getMethods()[i].getParameterTypes();
        		for (int iCnt=0; iCnt < p.length; iCnt++)
        			System.out.println("Parameter : "
        					+ p[iCnt].getName());
        	}
        } 
        catch (Exception e) {
        	System.out.println(e);
        }

 

        for (int iCnt=0; 
             iCnt < stk1.peek().getClass().getMethods().length; 
             iCnt++)
          System.out.println("Name of Top-of-stack object, method number "  
                             + iCnt 
                             + " is: " 
                             + stk1.peek().getClass().getMethods()[iCnt]);


        // invoke() mit objekt-abhängiger Methode. Die Methode wird
        // auf dem Objekt stk1.peek() (hier vom Typ Ttt) angewendet.
        try {
        	System.out.println("Name of Top-of-stack Class = " 
        			+ stk1.peek().getClass().getName()
        			+ " has value "
        			+ stk1.peek().toString()
        			+ " which is the same as "
        			+ stk1.peek().getClass().getMethods()[0].
        			invoke(stk1.peek()));
        }
        catch (java.lang.IllegalAccessException e){
        	System.out.println(e);
        }
        catch (java.lang.reflect.InvocationTargetException e){
        	System.out.println(e);
        }

        // invoke() auf stk-Methode (Nummer 10 ist push()) mit einem
        // Parameter anwenden:
        Object oa[] = new Object[1];
        oa[0] = new String("String-auf-den-Stack");

        try {
        	stk1.getClass().getMethods()[2].invoke(stk1,oa);
        }
        catch (java.lang.IllegalAccessException e){
        	System.out.println(e);
        }
        catch (java.lang.reflect.InvocationTargetException e){
        	System.out.println(e);
        }

        System.out.println("Mit invoke() auf den Stack gelegt: "
        		+ stk1.pop());

    }

}
