#ifndef TRANSITION_H
#define TRANSITION_H

#include <rtt_test_types.h>

/* Datenstruktur fr eine Transition. */
struct sctransition {
  struct scstate *pTarget; /* Zielzustand der Transition. */
  struct scsignal *pSignal; /* (optionales) Signal, welches die Transition
                               anstt. */
  struct scguard *pGuard; /* Bedingung, welche das Freischalten der Transition
                             bewacht. */
  struct scaction *(*pActions)[]; /* Aktionen, die beim Feuern der Transition
                                     ausgefhrt werden. */
  uint64_t actionCount; /* Tatschliche Anzahl von Aktionen. */
  uint64_t maxActionCount; /* Maximale Anzahl von Aktionen. */
  uint64_t fireCount; /* Hufigkeit des Feuerns der Transition. */
};

/* Erzeugt eine Transition mit angegebenem Zielzustand, Signal, Wchter
   und Aktion. */
struct sctransition *transitionCreate (struct scstate *pTarget,
                                       struct scsignal *pSignal,
                                       struct scguard *pGuard,
                                       uint64_t maxActionCount);
/* Fgt der angegebenen Transition eine Aktion zu, wenn sie noch
   weniger als actionCount enthlt. */
void transitionAddAction (struct sctransition *pTransition,
                          struct scaction *pAction);
/* Gibt zurck, ob die Transition freigeschaltet ist, d.h. ob das Ereignis
   anliegt und der Wchter wahr ist. */
bool_t transitionIsEnabled (struct sctransition *pTransition);
/* Lsst die Transition feuern: alle Aktionen der Transition werden
   ausgefhrt. Der Zielzustand wird zurckgegeben. Das Ereignis wird
   deaktiviert. */
struct scstate *transitionFire (struct sctransition *pTransition);
/* Vernichtet die angegebene Transition. */
void transitionDestroy (struct sctransition *pTransition);
/* Gibt zurck, wie oft die Transition gefeuert wurde. */
uint64_t transitionGetFireCount (struct sctransition *pTransition);

/* Schreibt die Transition menschenlesbar in den angegebenen Puffer.
   Der Puffer mu gro genug sein! */
void transitionSprintf (char *buf, struct sctransition *pTransition);

#endif
