#ifndef TIMERLIST_H
#define TIMERLIST_H

#include <rtt_test_types.h>

/* Datenstruktur fr die Verwaltung von mehreren Timern. */
struct sctimerlist {
  struct sctimer *(*pAllTimers)[]; /* Die verwalteten Timer. */
  uint64_t maxTimerCount; /* Maximale Anzahl von Timern. */
  uint64_t timerCount; /* Tatschliche Anzahl von Timern. */
};

/* Erzeugt eine Timer-Liste fr maximal maxTimerCount Timer. */
struct sctimerlist *timerlistCreate (uint64_t maxTimerCount);
/* Vernichtet die angegebene Timer-Liste. */
void timerlistDestroy (struct sctimerlist *pTimerlist);
/* Fgt einen Timer in die Liste ein, sofern noch Platz ist. */
void timerlistAddTimer (struct sctimerlist *pTimerlist,
                        struct sctimer *pTimer);
/* Gibt den Timer zurck, welcher als nchstes abluft.
   Falls kein Timer aktiv ist, wird NULL zurckgegeben. */
struct sctimer *timerlistGetEarliest (struct sctimerlist *pTimerlist);
/* Alle enthaltenen Timer werden neu berechnet. */
void timerlistRecalcAll (struct sctimerlist *pTimerlist);

/* Schreibt die Timer-Liste menschenlesbar in den angegebenen Puffer.
   Der Puffer mu gro genug sein! */
void timerlistSprintf (char *buf, struct sctimerlist *pTimerlist);

#endif
