#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "sctimerlist.h"
#include "sctimer.h"

struct sctimerlist *timerlistCreate (uint64_t maxTimerCount) {
  struct sctimerlist *pTimerlist =
    (struct sctimerlist*)malloc(sizeof(struct sctimerlist));
  pTimerlist->pAllTimers =
    (struct sctimer*(*)[])malloc(sizeof(struct sctimer*) * maxTimerCount);
  pTimerlist->maxTimerCount = maxTimerCount;
  pTimerlist->timerCount = 0;
  return pTimerlist;
}

void timerlistDestroy (struct sctimerlist *pTimerlist) {
  free(pTimerlist->pAllTimers);
  free(pTimerlist);
}

void timerlistAddTimer (struct sctimerlist *pTimerlist,
                        struct sctimer *pTimer) {
  if (pTimerlist->timerCount < pTimerlist->maxTimerCount) {
    (*(pTimerlist->pAllTimers))[pTimerlist->timerCount++] = pTimer;
  }
}

struct sctimer *timerlistGetEarliest (struct sctimerlist *pTimerlist) {
  struct sctimer *pTimer = NULL;
  uint64_t index;
  for (index = 0; index < pTimerlist->timerCount; ++index) {
    struct sctimer *pCurrent = (*(pTimerlist->pAllTimers))[index];
    if (pCurrent->active) {
      if (pTimer != NULL) {
        pTimer = timerGetEarlier(pTimer, pCurrent);
      }
      else {
        pTimer = pCurrent;
      }
    }
  }
  return pTimer;
}

void timerlistRecalcAll (struct sctimerlist *pTimerlist) {
  int index;
  for (index = 0; index < pTimerlist->timerCount; ++index) {
    timerRecalc((*(pTimerlist->pAllTimers))[index]);
  }
}

void timerlistSprintf (char *buf, struct sctimerlist *pTimerlist) {
  sprintf(buf, "timer list:\n");
  int index;
  for (index = 0; index < pTimerlist->timerCount; ++index) {
    sprintf(buf += strlen(buf), "  ");
    timerSprintf(buf += strlen(buf), (*(pTimerlist->pAllTimers))[index]);
    sprintf(buf += strlen(buf), "\n");
  }
}
