#ifndef TIMER_H
#define TIMER_H

#include <rtt_test_types.h>
#include <time.h>

/* Datenstruktur fr einen Timer. */
struct sctimer {
  char *name; /* Name. */
  uint64_t *pTimespec; /* Gesamtdauer in Mikrosekunden. */
  uint64_t *pRemaining; /* Verbleibende Dauer in Mikrosekunden .*/
  bool_t active; /* TRUE, genau dann wenn der Timer luft. */
  uint64_t *pActivationTimeTick; /* Absoluter Zeittick seit der letzten
                                    Berechung der verbleibenden Dauer. */
  struct scsignal *pElapsedSignal; /* Signal, welches beim Ablauf aktiviert
                                      wird. */
  uint64_t *pElapsedSignalRemaining; /* Hack: Zeitdauer, nach welcher das
                                        elapsed signal automatisch deaktiviert
                                        wird, wenn es nicht konsumiert wird. */
};

/* Erzeugt einen Timer mit der Laufzeit in Mikrosekunden. */
struct sctimer *timerCreate (char *name, uint64_t *pMicroSeconds);
/* Gibt das zugehrige elapsedTimer-Signal heraus. */
struct scsignal *timerGetSignal (struct sctimer *pTimer);
/* Gibt die verbleibende Zeit zurck. */
uint64_t *timerGetRemaining (struct sctimer *pTimer);
/* Vernichtet den angegebenen Timer. */
void timerDestroy (struct sctimer *pTimer);
/* Aktiviert oder deaktiviert den Timer. */
void timerSetActive (struct sctimer *pTimer, bool_t active);
/* Gibt an, ob der Timer abgelaufen ist. */
bool_t timerIsElapsed (struct sctimer *pTimer);
/* Der Timer wird neu berechnet, falls er aktiv ist. Dann wird die angegebene
   Zeit von der verbleibenden Zeit subtrahiert.
   Ist die verbleibende Zeit <= 0, dann
   wird sie auf 0 gesetzt, der Timer deaktiviert und das elapsedTimer()-Signal
   erzeugt. */
void timerRecalc (struct sctimer *pTimer);
/* Gibt den Timer zurck, welcher frher abluft. Beide Timer mssen
   aktiv sein. */
struct sctimer *timerGetEarlier (struct sctimer *pTimer1,
                                 struct sctimer *pTimer2);

/* Schreibt den Timer menschenlesbar in den angegebenen Puffer.
   Der Puffer mu gro genug sein! */
void timerSprintf (char *buf, struct sctimer *pTimer);

#endif
