#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/time.h>
#include "sctimer.h"
#include "scsignal.h"

void calcTimeTick (uint64_t *pTimeTick) {
  struct timeval tv; 
  struct timezone tz;
  if ( -1 == gettimeofday(&tv,&tz) ) {
    printf("error: gettimeofday fails\n");
  }
  (*pTimeTick) = (uint64_t)tv.tv_sec*1000000LL + (uint64_t)tv.tv_usec;
}

struct sctimer *timerCreate (char *name, uint64_t *pDuration) {
  struct sctimer *pTimer = (struct sctimer*)malloc(sizeof(struct sctimer));
  pTimer->name = name;
  pTimer->pTimespec = (uint64_t *)malloc(sizeof(uint64_t));
  (*(pTimer->pTimespec)) = *pDuration;
  pTimer->pRemaining = (uint64_t *)malloc(sizeof(uint64_t));
  (*(pTimer->pRemaining)) = *pDuration;
  pTimer->active = FALSE;
  pTimer->pActivationTimeTick = (uint64_t *)malloc(sizeof(uint64_t));
  char *signalName = (char*)malloc(strlen(name)+strlen("elapsedTimer()"+1));
  sprintf(signalName, "elapsedTimer(%s)", name);
  pTimer->pElapsedSignal = signalCreate(signalName);
  pTimer->pElapsedSignalRemaining = (uint64_t *)malloc(sizeof(uint64_t));
  return pTimer;
}

struct scsignal *timerGetSignal (struct sctimer *pTimer) {
  return pTimer->pElapsedSignal;
}

uint64_t *timerGetRemaining (struct sctimer *pTimer) {
  return pTimer->pRemaining;
}

void timerDestroy (struct sctimer *pTimer) {
  free(pTimer->pActivationTimeTick);
  free(pTimer->pTimespec);
  free(pTimer->pRemaining);
  free(pTimer->pElapsedSignal);
  free(pTimer->pElapsedSignalRemaining);
  free(pTimer);
}

void timerSetActive (struct sctimer *pTimer, bool_t active) {
  pTimer->active = active;
  (*(pTimer->pRemaining)) = (*(pTimer->pTimespec));
  calcTimeTick(pTimer->pActivationTimeTick);
}

bool_t timerIsElapsed (struct sctimer *pTimer) {
  return (!(pTimer->active) && ((*(pTimer->pRemaining)) == 0));
}

void timerRecalc (struct sctimer *pTimer) {
  uint64_t currentTimeTick;
  calcTimeTick(&currentTimeTick);
  uint64_t passedTime = currentTimeTick - *(pTimer->pActivationTimeTick);
  /* begin hack: this is for non-consumed elapsed timer signals */
  /* since we have no defined step semantics, they disappear */
  /* after 100 ms */
  /* should be good enough for our PLS example ... */
  if ((*(pTimer->pElapsedSignalRemaining)) <= passedTime) {
    signalSetActive(pTimer->pElapsedSignal, FALSE);
    (*(pTimer->pElapsedSignalRemaining)) = 0;
  }
  else {
    (*(pTimer->pElapsedSignalRemaining)) -= passedTime;
  }
  /* end hack.*/
  if (pTimer->active) {
    bool_t elapsed = (*(pTimer->pRemaining)) <= passedTime;
    if (elapsed) {
      (*(pTimer->pRemaining)) = 0;
      pTimer->active = FALSE;
      signalSetActive(pTimer->pElapsedSignal, TRUE);
      (*(pTimer->pElapsedSignalRemaining)) = 100000; /* 100 ms */
    }
    else {
      (*(pTimer->pRemaining)) -= passedTime;
    }
  }
  (*(pTimer->pActivationTimeTick)) = currentTimeTick;
}

void timerSprintf (char *buf, struct sctimer *pTimer) {
  sprintf(buf, "T(%s,%s,%llu/%llu microsec)", pTimer->name,
          pTimer->active ? "active" : "inactive",
          *(pTimer->pRemaining),
          *(pTimer->pTimespec));
}

struct sctimer *timerGetEarlier (struct sctimer *pTimer1,
                                 struct sctimer *pTimer2) {
  if (pTimer1->active && pTimer2->active) {
    return
      (*(pTimer1->pRemaining)) <= (*(pTimer2->pRemaining))
      ? pTimer1
      : pTimer2;
  }
  else if (pTimer1->active) {
    return pTimer1;
  }
  else if (pTimer2->active) {
    return pTimer2;
  }
  else {
    return pTimer1 /*NULL?!?*/;
  }
}
