#ifndef STATECHART_H
#define STATECHART_H

#include <rtt_test_types.h>

/* Datenstruktur fr ein Statechart. */
struct scstatechart {
  char *name; /* Name. */
  struct scstate *pStartState; /* Startzustand. */
  uint64_t maxStateCount; /* Maximale Anzahl enthaltener Zustnde. */
};

/* Erzeugt ein Statechart. */
struct scstatechart *statechartCreate (char *name,
                                       struct scstate *pStartState,
                                       uint64_t maxStateCount);
/* Vernichtet das angegebene Statechart. */
void statechartDestroy (struct scstatechart *pStatechart);
/* Gibt den Startzustand heraus. */
struct scstate *statechartGetStartState (struct scstatechart *pStatechart);

/* Schreibt das Statechart menschenlesbar in den angegebenen Puffer.
   Der Puffer mu gro genug sein! */
void statechartSprintf (char *buf, struct scstatechart *pStatechart);

#endif
