#ifndef STATE_H
#define STATE_H

#include <rtt_test_types.h>

/* Datenstruktur fr einen Zustand (State, Location). */
struct scstate {
  char *name; /* Name. */
  struct sctransition *(*pTransitions)[]; /* Ausgehende Transitionen. */
  struct sctransition *(*pEnabledTransitions)[]; /* Freigeschaltete ausgehende
                                                    Transitionen. */
  uint64_t maxTransitionCount; /* Maximale Anzahl ausgehender Transitionen. */
  uint64_t transitionCount; /* Tatschliche Anzahl ausgehender Transitionen. */
  uint64_t visitCount; /* Anzahl der "Besuche" des Zustands, d.h. wie oft er
                          betreten wurde. */
};

/* Erzeugt einen Zustand, der maximal maxTransitionCount ausgehende
   Transitionen enthalten kann. */
struct scstate *stateCreate (char *name, uint64_t maxTransitionCount);
/* Fgt dem angegebenen Zustand eine ausgehende Transition zu, wenn er noch
   weniger als transitionCount enthlt. */
void stateAddTransition (struct scstate *pState,
                         struct sctransition *pTransition);
/* Vernichtet den angegebenen Zustand. */
void stateDestroy (struct scstate *pState);
/* Gibt ein Feld mit den momentan freigeschalteten Transitionen heraus.
   Das Feld wird beim Aufruf dieser Funktion berechnet.
   Der Rckgabewert gibt an, ob freigeschaltete Transitionen existieren oder
   nicht. */
bool_t stateGetEnabledTransitions (struct scstate *pState,
                                   struct sctransition *(**ppEnabledTransitions)[],
                                   uint64_t *pTransitionCount);
/* Der angegebene Zustand wird betreten und der Besuchszhler
   inkrementiert. */
void stateEnter (struct scstate *pState);
/* Gibt die Anzahl der "Besuche" zurck, d.h. wie oft der Zustand betreten
   wurde. */
uint64_t stateGetVisitCount (struct scstate *pState);

/* Schreibt den Zustand menschenlesbar in den angegebenen Puffer.
   Der Puffer mu gro genug sein! */
void stateSprintf (char *buf, struct scstate *pState);

#endif
