#ifndef SIGNAL_H
#define SIGNAL_H

#include <rtt_test_types.h>

/* Datenstruktur fr ein Signal (Ereignis, Event). */
struct scsignal {
  char *name; /* Name. */
  bool_t active; /* TRUE heit, da das Signal anliegt,
                    sonst ist es nicht da. */
};

/* Erzeugt ein Signal. */
struct scsignal *signalCreate (char *name);
/* Vernichtet die angegebene Signal. */
void signalDestroy (struct scsignal *pSignal);
/* Aktiviert (d.h. erzeugt ein Auftreten) oder deaktiviert (d.h. konsumiert)
   das Signal. */
void signalSetActive (struct scsignal *pSignal, bool_t active);
/* Gibt zurck, ob das Signal aktiv ist. */
bool_t signalIsActive (struct scsignal *pSignal);

/* Schreibt das Signal menschenlesbar in den angegebenen Puffer.
   Der Puffer mu gro genug sein! */
void signalSprintf (char *buf, struct scsignal *pSignal);

#endif
