#ifndef GUARD_H
#define GUARD_H

#include <rtt_test_types.h>

/* Datenstruktur fr einen Wchter (Guard, Condition). */
struct scguard {
  char *name; /* Name. */
  bool_t (*pFunction)(); /* Boolesche Funktion zum Prfen der Bedingung. */
};

/* Erzeugt einen Wchter, welcher gem der angegebenen booleschen Funktion
   ausgewertet wird. */
struct scguard *guardCreate (char *name, bool_t (*pFunction)());
/* Vernichtet die angegebene Wchter. */
void guardDestroy (struct scguard *pGuard);
/* Wertet den Wchter aus. */
bool_t guardEvaluate (struct scguard *pGuard);

/* Schreibt den Wchter menschenlesbar in den angegebenen Puffer.
   Der Puffer mu gro genug sein! */
void guardSprintf (char *buf, struct scguard *pGuard);

#endif
