#ifndef ACTION_H
#define ACTION_H

#include <rtt_test_types.h>

typedef enum {
  ASSIGNMENT_ACTION, SIGNAL_ACTION, SETTIMER_ACTION
} actiontype_t;

/* Datenstruktur fr Aktionen. */
struct scaction {
  char *name; /* Name. */
  void (*pAssignmentFunction)(); /* (optionale) Funktion fr Zuweisungen. */
  struct scsignal *pSignal; /* (optionales) Signal. */
  struct sctimer *pTimer; /* (optionaler) Timer. */
  actiontype_t type; /* Art der Aktion. */
};

/* Erzeugt eine Aktion, welche gem der angegebenen Funktion Zuweisungen zu
   globalen Variablen macht. */
struct scaction *actionCreateAssignmentAction (char *name,
                                               void (*pFunction)());
/* Erzeugt eine Aktion, welche den angegebenen Timer (zurck-)setzt. */
struct scaction *actionCreateTimerAction (struct sctimer *pTimer);
/* Erzeugt eine Aktion, welche das angegebene Signal erzeugt. */
struct scaction *actionCreateSignalAction (struct scsignal *pSignal);
/* Vernichtet die angegebene Action. */
void actionDestroy (struct scaction *pAction);
/* Fhrt die angegebene Aktion aus. */
void actionRun (struct scaction *pAction);

/* Schreibt die Action menschenlesbar in den angegebenen Puffer.
   Der Puffer mu gro genug sein! */
void actionSprintf (char *buf, struct scaction *pAction);

#endif
