#include <stdio.h>
#include "plsenv.h"

bool paramState[5][32];
bool discState[7];

int main (int argc, char** argv) {
  /* parameter init */
  int index;
  paramState[PARAM_DECOMP_ACTIVATION][0] = true;
  paramState[PARAM_AUTO_SOLUTION_TYPE][0] = SOLUTION1;
  for (index = 0; index < 31; index = index + 1)
    {
      switch(index) {
      case 0: case 1: case 29: case 30: case 28:
        paramState[PARAM_EXIT_SIGN_ASSIGNED][index] = true;
        paramState[PARAM_FSB_SIGN_ASSIGNED][index] = true;
        paramState[PARAM_RTS_SIGN_ASSIGNED][index] = true;
        break;
      default:
        paramState[PARAM_EXIT_SIGN_ASSIGNED][index] = false;
        paramState[PARAM_FSB_SIGN_ASSIGNED][index] = false;
        paramState[PARAM_RTS_SIGN_ASSIGNED][index] = false;
      }
    }
  /* disc init */
  discState[FSB_SWITCH_ON] = false;
  discState[FSB_SWITCH_AUTO] = false;
  discState[PRESSURE_LOW1] = true;
  discState[PRESSURE_LOW2] = true;
  discState[LDG_DOWN_LOCKED] = false;
  discState[SLAT_ACTIVE1] = false;
  discState[SLAT_ACTIVE2] = false;
  /* run */
  plsMain();
}
bool getDisc(inputId id) { return discState[id]; }
void setSign(int addr, outputId id, bool active) {
  /* printf("setSign(addr==%d, type==%d, active==%d\n", addr, type, active); */
}
bool getParam(paramId id, int index) {
  return paramState[id][index];
}
