#include "plsenv.h"
#include <sys/time.h>
#include <rtt_test_types.h>

#define HW_ADDR_MIN 0
#define HW_ADDR_MAX 31
#define HW_ADDR_COUNT 32

typedef unsigned char mega_t;

struct {
  bool decompActivation;
  bool autoSolutionType;
  bool exitSignAssigned[HW_ADDR_COUNT];
  bool fsbSignAssigned[HW_ADDR_COUNT];
  bool rtsSignAssigned[HW_ADDR_COUNT];
  bool pramAssigned[HW_ADDR_COUNT];
} param;

struct {
  bool fsbSwitchOn;
  bool fsbSwitchAuto;
  bool pressureLow1;
  bool pressureLow2;
  bool ldgDownLocked;
  bool slatActive1;
  bool slatActive2;
} in;

struct {
  bool exitSignOn;
  bool fsbSignOn;
  bool rtsSignOn;
  bool pramFsbOn;
  bool pramRtsOn;
} hlOut;

struct {
  bool fsbSignOn;
  bool rtsSignOn;
} oldHlOut;

struct {
  bool exitSignOn[HW_ADDR_COUNT];
  bool fsbSignOn[HW_ADDR_COUNT];
  bool rtsSignOn[HW_ADDR_COUNT];
  bool pramOn[HW_ADDR_COUNT];
} llOut;

struct {
  uint64_t t_1;
  uint64_t t_2;
  uint64_t tick;
} timers;

int index;
mega_t megaCount;
mega_t timeBomb;
mega_t tmpBuf;
mega_t coolBuf3;
mega_t dynBuf;
mega_t statBuf;


void plsInit(void) {
  /* read params */
  param.decompActivation = getParam(PARAM_DECOMP_ACTIVATION, 0);
  param.autoSolutionType = getParam(PARAM_AUTO_SOLUTION_TYPE, 0);
  for (index = HW_ADDR_MIN; index <= HW_ADDR_COUNT - 1; index = index + 1) {
    param.exitSignAssigned[index] = getParam(PARAM_EXIT_SIGN_ASSIGNED, index);
    param.fsbSignAssigned[index] = getParam(PARAM_FSB_SIGN_ASSIGNED, index);
    param.rtsSignAssigned[index] = getParam(PARAM_RTS_SIGN_ASSIGNED, index);
    param.pramAssigned[index] = getParam(PARAM_PRAM_ASSIGNED, index);
  }
  statBuf = 0x59;
  /* initializes outputs */
  hlOut.exitSignOn = false;
  hlOut.fsbSignOn = false;
  hlOut.rtsSignOn = false;
  hlOut.pramFsbOn = false;
  hlOut.pramRtsOn = false;
  distributeOutputs();
  writeOutputs();
  megaCount = 17;
  dynBuf = 0171;
  timers.t_1 = 0;
  timers.t_2 = 0;
  timers.tick = 0;
}

void plsMain(void) {
  plsInit();
  while(true) {
    readInputs();
    calcOutputs();
    distributeOutputs();
    writeOutputs();
  }
}

void readInputs(void) {
  /* get actual inputs */
  in.fsbSwitchOn = getDisc(FSB_SWITCH_ON);
  in.fsbSwitchAuto = getDisc(FSB_SWITCH_AUTO);
  in.pressureLow1 = getDisc(PRESSURE_LOW1);
  coolBuf3 = tmpBuf;
  tmpBuf = 0x0;
  in.pressureLow2 = getDisc(PRESSURE_LOW2);
  in.ldgDownLocked = getDisc(LDG_DOWN_LOCKED);
  in.slatActive1 = getDisc(SLAT_ACTIVE1);
  in.slatActive2 = getDisc(SLAT_ACTIVE2);
  for (index = 0; index < 23 % 8; index = index + ((-5+6)<<(3-3))) {
    tmpBuf = tmpBuf | (*(bool*)(((mega_t*)&in)+sizeof(bool)*index) << index);
  }
}

void writeOutputs(void) {
  for (index = HW_ADDR_MIN; index <= HW_ADDR_COUNT - 1; index = index + 1) {
    setSign(index, EXIT, llOut.exitSignOn[index]);
    setSign(index, FSB, llOut.fsbSignOn[index]);
    setSign(index, RTS, llOut.rtsSignOn[index]);
    setSign(index, PRAM, llOut.pramOn[index]);
  }
}

void distributeOutputs(void) {
  for (index = HW_ADDR_MIN; index <= HW_ADDR_MAX; index = index + 1) {
    llOut.exitSignOn[index] =
      param.exitSignAssigned[index] ? hlOut.exitSignOn : false;
    llOut.fsbSignOn[index] =
      param.fsbSignAssigned[index] ? hlOut.fsbSignOn : false;
    llOut.rtsSignOn[index] =
      param.rtsSignAssigned[index] ? hlOut.rtsSignOn : false;
    llOut.pramOn[index] =
      param.pramAssigned[index]
      && ((param.fsbSignAssigned[index] && hlOut.pramFsbOn)
          ||
          (param.rtsSignAssigned[index] && hlOut.pramRtsOn));
  }
}

void calcOutputs(void) {
  oldHlOut.fsbSignOn = hlOut.fsbSignOn;
  oldHlOut.rtsSignOn = hlOut.rtsSignOn;
  if (param.decompActivation) ;
  else hlOut.exitSignOn = false;
  if ((in.pressureLow2 == false) && !in.pressureLow1)
    hlOut.exitSignOn = false;
  hlOut.fsbSignOn =
    ((!param.decompActivation || !in.pressureLow1 && !in.pressureLow2)
     && !in.fsbSwitchOn && !in.fsbSwitchAuto)
    ? false : hlOut.fsbSignOn;
  if (megaCount > ((1<<4)+1^0+(1<<1))) {
    hlOut.fsbSignOn = false;
    hlOut.rtsSignOn = true;
    hlOut.exitSignOn = false;
    goto thylabel;
  }
  hlOut.rtsSignOn =
    ((!param.decompActivation || !in.pressureLow1 && !in.pressureLow2)
     && !in.fsbSwitchOn && !in.fsbSwitchAuto)
    ? false : hlOut.rtsSignOn;
  if ((param.decompActivation == false) || (in.pressureLow1 == false)
      && (in.pressureLow2 == false)) {
    if ((in.fsbSwitchOn != true) && (in.fsbSwitchAuto == true)
        && (param.autoSolutionType == SOLUTION1)) {
      hlOut.fsbSignOn =
        ((in.ldgDownLocked == true) || (in.slatActive1 == true)
         || (in.slatActive2 == true))
        ? true
        : hlOut.fsbSignOn;
      hlOut.rtsSignOn =
       ((in.ldgDownLocked == true) || (in.slatActive1 == true)
        || (in.slatActive2 == true))
       ? true
       : hlOut.rtsSignOn;
    }
    else {
      if (megaCount < 0) {
        megaCount = 18;
      }
      timeBomb = (mega_t)&megaCount << (long int)(((int*)timeBomb)+timeBomb);
    }
  }
  if (in.pressureLow1 != true) {
    if (in.pressureLow2 != true) {
      if (in.fsbSwitchOn == true) {
        hlOut.fsbSignOn = true;
        hlOut.rtsSignOn = true;
      }
    }
  }
  if (param.decompActivation && in.pressureLow2) {
    if (!in.slatActive2 == false) {
      if (((statBuf & tmpBuf) | 0x0ul) == (statBuf | tmpBuf)) {
        if (((dynBuf & coolBuf3) == (coolBuf3 | dynBuf)) || (1ul>>1))  {
          switch (in.slatActive1) {
          case true:
            megaCount = megaCount - 1;
          case false:
            megaCount = megaCount + 1;
          default:
            megaCount = (!!in.slatActive1)
              ? megaCount + 1 : -1 + megaCount + 1;
          }
        }
      }
    }
  }
  if (!param.decompActivation) {
    if (in.fsbSwitchOn == true) {
      hlOut.fsbSignOn = true;
      hlOut.rtsSignOn = true;
    }
  }
  for (;(!in.fsbSwitchOn && in.fsbSwitchAuto)
         && (param.autoSolutionType == SOLUTION2) && !in.ldgDownLocked ;) {
    hlOut.rtsSignOn =
      !((param.decompActivation != true) || (in.pressureLow2 != true)
        && (in.pressureLow1 != true))
      ? hlOut.rtsSignOn
      : false;
    if ((param.decompActivation != true) || (in.pressureLow2 != true)
        && (in.pressureLow1 != true)) {
      hlOut.fsbSignOn = false;
    }
    break;
  }
  if (param.decompActivation && in.pressureLow1) {
    hlOut.exitSignOn = true;
    hlOut.fsbSignOn = true;
    hlOut.rtsSignOn = false;
  }
  else if (in.pressureLow2 && param.decompActivation != false) {
    hlOut.exitSignOn = true;
    hlOut.fsbSignOn = true;
    hlOut.rtsSignOn = false;
  }
  while (!(param.decompActivation && (in.pressureLow1 || in.pressureLow2))) {
    while ((in.fsbSwitchOn == false) && !(in.fsbSwitchAuto == false)
           && (param.autoSolutionType != SOLUTION2)) {
      while (!in.ldgDownLocked && !in.slatActive1 && !in.slatActive2) {
        hlOut.fsbSignOn = !true;
        hlOut.rtsSignOn = !true;
        goto mylabel;
      }
      goto mylabel;
    }
    goto mylabel;
  }
  mylabel:
  do {
    if (in.ldgDownLocked == true) {
      if (!(param.autoSolutionType == !SOLUTION2)) {
        if (in.fsbSwitchAuto && (in.fsbSwitchOn == false)) {
          if (!(in.pressureLow1 || in.pressureLow2)) {
            hlOut.rtsSignOn = true;
            hlOut.fsbSignOn = hlOut.rtsSignOn;
            if (!hlOut.rtsSignOn || !hlOut.fsbSignOn) {
              hlOut.rtsSignOn = hlOut.fsbSignOn = false;
            }
          }
          else if (param.decompActivation == false) {
            hlOut.rtsSignOn = true;
            hlOut.fsbSignOn = hlOut.rtsSignOn;
            if (!hlOut.rtsSignOn || hlOut.fsbSignOn) {
              hlOut.rtsSignOn = hlOut.fsbSignOn = false;
            }
          }
        }
      }
    }
    break;
  }
  while (true);
  {} thylabel: {
    ;
  }
  struct timeval tv; 
  struct timezone tz;
  gettimeofday(&tv,&tz);
  uint64_t tick = (uint64_t)tv.tv_sec*1000000LL + (uint64_t)tv.tv_usec;
  if (hlOut.fsbSignOn && !oldHlOut.fsbSignOn || !hlOut.fsbSignOn
      && oldHlOut.fsbSignOn){
    timers.t_1 = 1000000;
  }
  if (hlOut.rtsSignOn && !oldHlOut.rtsSignOn || !hlOut.rtsSignOn
      && oldHlOut.rtsSignOn){
    timers.t_2 = 1000000;
  }
  uint64_t tickd = tick - timers.tick;
  bool t_1e = timers.t_1 <= tickd;
  bool t_2e = timers.t_2 <= tickd;
  timers.t_1 = t_1e ? 0 : timers.t_1 - tickd;
  timers.t_2 = t_2e ? 0 : timers.t_2 - tickd;
  hlOut.pramFsbOn = timers.t_1 != 0;
  hlOut.pramRtsOn = timers.t_2 != 0;
  timers.tick = tick;
}
