/*
/////////////////////////////////////////////////////////////////////
//
// Verified Systems International GmbH
// Parkstrasse 78 
// D-28209 Bremen
// Germany
// Tel.  : +49 421 344576
// Fax   : +49 421 344586
// e-mail: info@verified.de
//
//--------------------------------------------------------------------
//
// (C) Copyright Verified Systems International GmbH $Date: 2004/05/06 22:42:25 $
//
//--------------------------------------------------------------------
//
// Product: RT-Tester template for test configuration / initialisation
//
//--------------------------------------------------------------------
//
// File Identification: $Id: RTTcontext.h,v 1.1 2004/05/06 22:42:25 alien Exp $
//
// First edition by: Oliver Mller
// Last update by $Author: alien $
//
//--------------------------------------------------------------------
//
// Description: 
//   Default contex for global stubs
//   RTT 6.x STL Preprocessor, parsing .tpl .conf .rts files
//
// -------------------------------------------------------------
// @TABLE OF CONTENTS:		       [TOCD: 11:05 27 Nov 2003]
//
//      [0.1] DEFINITIONS
//      [0.2] global variables
//  [1] Global Function Declarations
//      [1.1] Service Functions
//      [1.2] AM and LWP context functions
//      [1.3] AM context functions
//      [1.4] LWP context functions
//      [1.5] channel context functions
//      [1.6] Service Functions
// -------------------------------------------------------------*/


#ifndef _RTTCONTEXT_H
#define _RTTCONTEXT_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <pth.h>

#include <stdlib.h>
#include <stdio.h>


#include "rttctxlib.h"
#include "rtt_test_config.h"
#include "RTT_user_printfuns.h"


// ///////////////////////////////////////////////
// [0.1] DEFINITIONS
// ///////////////////////////////////////////////

// ///////////////////////////////////////////////
// [0.2] global variables
// ///////////////////////////////////////////////

/** @var RTTglobal_setup_t RTTgs;
 *  A global variable containing the global setup of a test case.
 */
extern RTTglobal_setup_t RTTgs;

/** @var uint32_t rtt_SUT_am_id;
 *  A global variable containing the am id of the abstract machine that is
 *  specified as the system under test (SUT) in the configuration file.
 */
//extern uint32_t rtt_SUT_am_id;

/** @var uint64_t rttStartOfTestTic;
 *  The global timetick at which the test did start.
 */
extern uint64_t rttStartOfTestTic;

/** @var rttStartOfTestEpoch
 *  The global time epoch used for the time tick calculation.
 */
extern time_t rttStartOfTestEpoch;

/** @var uint32_t rtt_config_num_am;
 *  A global variables storing the number of activated AMs. It is set at
 *  runtime according to the value of RTT_CONFIG_NUM_AM.
 */
extern uint32_t rtt_config_num_am;

/** @var uint32_t rtt_config_num_lwp;
 *  A global variables storing the number of LWPs of a test case. It is set at
 *  runtime according to the value of RTT_CONFIG_NUM_LWP.
 */
extern uint32_t rtt_config_num_lwp;


/** @var rtt_ti_level_t rttTiLevel;
 *  The global test integration level of a test case.
 */
extern rtt_ti_level_t rttTiLevel;


// ///////////////////////////////////////////////////////////////////
// [1] Global Function Declarations
// ///////////////////////////////////////////////////////////////////


// ///////////////////////////////////////////////
// [1.1] Service Functions
// ///////////////////////////////////////////////

/**
 * Function rttAllWarnings. 
 * Returns the sum of all warnings of all defined abstract machines.
 * Warning: this function is not thread safe.
 */
extern long int rttAllWarnings();

/**
 * Function rttAllFailures. 
 * Returns the sum of all failures of all defined abstract machines.
 * Warning: this function is not thread safe.
 */
extern long int rttAllFailures();

/**
 * Function rttStandardFormat. Standard logging function for unit test AMs.
 * 
 * @param amId       internal number of the abstract machine
 * @param eventFlag  condition/event/action flag
 * @param string     text string to be logged
 */
extern void rttStandardFormat(unsigned long, unsigned long, char*);

/**
 * Function rttAMContext_compute_verdict.Create a test verdict according
 * to context informations.
 * 
 * @param amNumber  internal number of the abstract machine
 * @param nWarnings number of warnings (fails of  @rttCheck)
 * @param nErrors   number of errors   (fails of  @rttAssert)
 * @param testStep  last exectued test step
 * 
 */
extern void rttAMContext_compute_verdict(unsigned long, 
					 unsigned long,
					 unsigned long);

// ///////////////////////////////////////////////
// [1.2] AM and LWP context functions
// ///////////////////////////////////////////////

/**
 * Function stublevel_context_INIT.
 * Initialisation of stub test integration levels
 */
extern void stublevel_context_INIT();

/**
 * Function stublevel_context_FINIT.
 * Finalisation of stub test integration levels
 */
extern void stublevel_context_FINIT();

// ///////////////////////////////////////////////
// [1.3] AM context functions
// ///////////////////////////////////////////////

/**
 * Function am_context_INIT.
 * Initialisation of AM context.
 */
extern void am_context_INIT();

/**
 * Function am_context_FINIT.
 * Finalisation of AM context.
 */
extern void am_context_FINIT();

// ///////////////////////////////////////////////
// [1.4] LWP context functions
// ///////////////////////////////////////////////

/**
 * Function lwp_context_INIT.
 * Initialisation of LWP context.
 */
extern void lwp_context_INIT();

/**
 * Function lwp_context_FINIT.
 * Finalisation of LWP context.
 */
extern void lwp_context_FINIT();

// ///////////////////////////////////////////////
// [1.5] channel context functions
// ///////////////////////////////////////////////

/**
 * Function channel_context_INIT.
 * Initialisation of channel context.
 */
void channel_context_INIT();

/**
 * Function channel_context_FINIT.
 * Finalisation of channel context.
 */
void channel_context_FINIT();

/**
 * Function rttGetCnlSpec. Retrieves the channel specification
 * setup for a given channel name on an LWP.
 *
 * @param cnl Name of the channel
 * @param lwp_id The number of the LWP.
 */
rttCnlSpec_t *rttGetCnlSpec(char *cnl, uint32_t lwp_id);

/**
 * Function rttPruneReadIndex. Remove duplicate read index array
 * initialisation. All ports of a channel of an abstract machine
 * should use the same read index.
 *
 * @param am_id Internal number of an abstract machine.
 */
void rttPruneReadIndex(uint32_t am_id);

/**
 * Function rttFreeReadIndex. Since read indices may be used by
 * multiple ports, the allocated memory must not be freed for each
 * port, but only once. This function frees the allocated memory once
 * and sets all referenced the rIdxPtr to NULL.
 *
 * @param am_id Internal number of an abstract machine.
 * @param rIdxPtr Read index pointer
 */
void rttFreeReadIndex(uint32_t am_id, uint32_t *rIdxPtr);

// ///////////////////////////////////////////////
// [1.6] Service Functions
// ///////////////////////////////////////////////

/**
 * Function rttStandardFormat. Standard logging function for unit test AMs.
 * 
 * @param amId       internal number of the abstract machine
 * @param eventFlag  condition/event/action flag
 * @param string     text string to be logged
 */
extern void rttStandardFormat(unsigned long, unsigned long, char*);


// -------------------------------------------------------------------------

#endif
