#ifndef __PLSENV_H__
#define __PLSENV_H__

#ifndef bool
#define bool int
#define true 1
#define false 0
#endif

typedef enum {
  FSB_SWITCH_ON, FSB_SWITCH_AUTO, PRESSURE_LOW1, PRESSURE_LOW2,
  LDG_DOWN_LOCKED, SLAT_ACTIVE1, SLAT_ACTIVE2
} discId;

typedef enum {
  EXIT, FSB, RTS
} signType;

typedef enum {
  PARAM_DECOMP_ACTIVATION, PARAM_AUTO_SOLUTION_TYPE,
  PARAM_EXIT_SIGN_ASSIGNED, PARAM_FSB_SIGN_ASSIGNED, PARAM_RTS_SIGN_ASSIGNED
} paramId;

#define SOLUTION1 false
#define SOLUTION2 true

bool getDisc(discId);
void setSign(int addr, signType, bool);
bool getParam(paramId, int index);

#endif
