#include "plsenv.h"

#define HW_ADDR_MIN 0
#define HW_ADDR_MAX 30
#define HW_ADDR_COUNT 32

struct {
  bool decompActivation;
  bool autoSolutionType;
  bool exitSignAssigned[HW_ADDR_COUNT];
  bool fsbSignAssigned[HW_ADDR_COUNT];
  bool rtsSignAssigned[HW_ADDR_COUNT];
} param;

struct {
  bool fsbSwitchOn;
  bool fsbSwitchAuto;
  bool pressureLow1;
  bool pressureLow2;
  bool ldgDownLocked;
  bool slatActive1;
  bool slatActive2;
} in;

struct {
  bool exitSignOn;
  bool fsbSignOn;
  bool rtsSignOn;
} hlOut;

struct {
  bool exitSignOn[HW_ADDR_COUNT];
  bool fsbSignOn[HW_ADDR_COUNT];
  bool rtsSignOn[HW_ADDR_COUNT];
} llOut;

int index;
int megaCount;

void plsInit(void) {
  /* read params */
  param.decompActivation = getParam(PARAM_DECOMP_ACTIVATION, 0);
  param.autoSolutionType = getParam(PARAM_AUTO_SOLUTION_TYPE, 0);
  for (index = HW_ADDR_MIN; index <= HW_ADDR_COUNT - 1; index = index + 1) {
    param.exitSignAssigned[index] = getParam(PARAM_EXIT_SIGN_ASSIGNED, index);
    param.fsbSignAssigned[index] = getParam(PARAM_FSB_SIGN_ASSIGNED, index);
    param.rtsSignAssigned[index] = getParam(PARAM_RTS_SIGN_ASSIGNED, index);
  }
  /* initializes outputs */
  hlOut.exitSignOn = false;
  hlOut.fsbSignOn = false;
  hlOut.rtsSignOn = false;
  distributeOutputs();
  writeOutputs();
  megaCount = 17;
}

void plsMain(void) {
  plsInit();
  while(true) {
    readInputs();
    calcOutputs();
    distributeOutputs();
    writeOutputs();
  }
}

void readInputs(void) {
  /* get actual inputs */
  in.fsbSwitchOn = getDisc(FSB_SWITCH_ON);
  in.fsbSwitchAuto = getDisc(FSB_SWITCH_AUTO);
  in.pressureLow1 = getDisc(PRESSURE_LOW1);
  in.pressureLow2 = getDisc(PRESSURE_LOW2);
  in.ldgDownLocked = getDisc(LDG_DOWN_LOCKED);
  in.slatActive1 = getDisc(SLAT_ACTIVE1);
  in.slatActive2 = getDisc(SLAT_ACTIVE2);
}

void writeOutputs(void) {
  for (index = HW_ADDR_MIN; index <= HW_ADDR_COUNT - 1; index = index + 1) {
    if (param.exitSignAssigned[index]) {
      setSign(index, EXIT, llOut.exitSignOn[index]);
    }
    if (param.fsbSignAssigned[index]) {
      setSign(index, FSB, llOut.fsbSignOn[index]);
    }
    if (param.rtsSignAssigned[index]) {
      setSign(index, RTS, llOut.rtsSignOn[index]);
    }
  }
}

void distributeOutputs(void) {
  for (index = HW_ADDR_MIN; index <= HW_ADDR_MAX; index = index + 1) {
    if (param.exitSignAssigned[index]) {
      llOut.exitSignOn[index] = hlOut.exitSignOn;
    }
    if (param.fsbSignAssigned[index]) {
      llOut.fsbSignOn[index] = hlOut.fsbSignOn;
    }
    if (param.rtsSignAssigned[index]) {
      llOut.rtsSignOn[index] = hlOut.rtsSignOn;
    }
  }
}

void calcOutputs(void) {
  if (param.decompActivation) ;
  else hlOut.exitSignOn = false;
  if ((in.pressureLow2 == false) && !in.pressureLow1)
    hlOut.exitSignOn = false;
  hlOut.fsbSignOn =
    ((!param.decompActivation || !in.pressureLow1 && !in.pressureLow2)
     && !in.fsbSwitchOn && !in.fsbSwitchAuto)
    ? false : hlOut.fsbSignOn;
  hlOut.rtsSignOn =
    ((!param.decompActivation || !in.pressureLow1 && !in.pressureLow2)
     && !in.fsbSwitchOn && !in.fsbSwitchAuto)
    ? false : hlOut.rtsSignOn;
  if ((param.decompActivation == false) || (in.pressureLow1 == false)
      && (in.pressureLow2 == false)) {
    if ((in.fsbSwitchOn != true) && (in.fsbSwitchOn == true)
        && (param.autoSolutionType == SOLUTION1)) {
      hlOut.fsbSignOn =
        ((in.ldgDownLocked == true) || (in.slatActive1 == true)
         || (in.slatActive2 == true))
        ? true
        : hlOut.fsbSignOn;
    }
    else megaCount = 18;
  }
  if (in.pressureLow1 != true) {
    if (in.pressureLow2 != true) {
      if (in.fsbSwitchOn == true) {
        hlOut.fsbSignOn = true;
        hlOut.rtsSignOn = true;
      }
    }
  }
  if (param.decompActivation && in.pressureLow2) {
    if (!in.slatActive2 == false) {
      switch (in.slatActive1) {
      case true:
        megaCount = megaCount + 1;
        break;
      case false:
        megaCount = megaCount - 1;
        break;
      default:
        megaCount = megaCount + 0;
      }
    }
  }
  if (!param.decompActivation) {
    if (in.fsbSwitchOn == true) {
      hlOut.fsbSignOn = true;
      hlOut.rtsSignOn = true;
    }
  }
  for (;(!in.fsbSwitchOn && in.fsbSwitchAuto)
         && (param.autoSolutionType == SOLUTION2) && !in.ldgDownLocked ;) {
    hlOut.rtsSignOn =
      !((param.decompActivation != true) || (in.pressureLow2 != true)
        && (in.pressureLow1 != true))
      ? hlOut.rtsSignOn
      : false;
    if ((param.decompActivation != true) || (in.pressureLow2 != true)
        && (in.pressureLow1 != true)) {
      hlOut.fsbSignOn = false;
    }
    break;
  }
  if (param.decompActivation && in.pressureLow1) {
    hlOut.exitSignOn = true;
    hlOut.fsbSignOn = true;
    hlOut.rtsSignOn = false;
  }
  else if (in.pressureLow2 && param.decompActivation != false) {
    hlOut.exitSignOn = true;
    hlOut.fsbSignOn = true;
    hlOut.rtsSignOn = false;
  }
  while (!(param.decompActivation && (in.pressureLow1 || in.pressureLow2))) {
    while ((in.fsbSwitchOn == false) && !(in.fsbSwitchAuto == false)
           && (param.autoSolutionType != SOLUTION2)) {
      while (!in.ldgDownLocked && !in.slatActive1 && !in.slatActive2) {
        hlOut.fsbSignOn = !true;
        hlOut.rtsSignOn = !true;
        goto mylabel;
      }
      goto mylabel;
    }
    goto mylabel;
  }
  mylabel:
  do {
    if (in.ldgDownLocked == true) {
      if (!(param.autoSolutionType == !SOLUTION2)) {
        if (in.fsbSwitchAuto && (in.fsbSwitchOn == false)) {
          if (!(in.pressureLow1 || in.pressureLow2)) {
            hlOut.rtsSignOn = true;
            hlOut.fsbSignOn = hlOut.rtsSignOn;
            if (!hlOut.rtsSignOn || !hlOut.fsbSignOn) {
              hlOut.rtsSignOn = hlOut.fsbSignOn = false;
            }
          }
          else if (param.decompActivation == false) {
            hlOut.rtsSignOn = true;
            hlOut.fsbSignOn = !hlOut.rtsSignOn;
            if (!hlOut.rtsSignOn || hlOut.fsbSignOn) {
              hlOut.rtsSignOn = hlOut.fsbSignOn = false;
            }
          }
        }
      }
    }
    break;
  }
  while (true);
}
